/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.TreeNode;

public class Tree<T>
implements Iterable<TreeNode<T>> {
    private final Map<T, List<T>> links = new TreeMap<T, List<T>>();
    private T root;

    public Tree(T root) {
        this.root = root;
        this.links.put(root, new LinkedList());
    }

    public void appendChild(T parent, T child) {
        List<T> children = this.getChildrenToAddTo(parent, child);
        children.add(child);
    }

    public void insertChild(T parent, T child, int index) {
        List<T> children = this.getChildrenToAddTo(parent, child);
        children.add(index, child);
    }

    private List<T> getChildrenToAddTo(T parent, T child) {
        if (!this.links.containsKey(parent)) {
            throw new IllegalArgumentException("The parent: " + parent + " does not exist!");
        }
        List<T> children = this.links.get(parent);
        this.links.put(child, new LinkedList());
        return children;
    }

    public List<T> getChildren(T parent) {
        return this.links.get(parent);
    }

    public T getRoot() {
        return this.root;
    }

    @Override
    public Iterator<TreeNode<T>> iterator() {
        return new TreeIterator();
    }

    private class TreeIterator
    implements Iterator<TreeNode<T>> {
        private final List<TreeNode<T>> nodes = new LinkedList();
        private int index = 0;

        public TreeIterator() {
            this.addChildNode(null, Tree.this.root);
        }

        private void addChildNode(T parent, T child) {
            List grandChildren = Tree.this.links.get(Tree.this.root);
            TreeNode node = new TreeNode(parent, child, grandChildren.isEmpty());
            this.nodes.add(node);
            for (Object grandChild : grandChildren) {
                this.addChildNode(child, grandChild);
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.nodes.size() - 1;
        }

        @Override
        public TreeNode<T> next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            TreeNode next = this.nodes.get(this.index - 1);
            ++this.index;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove items from a Tree!");
        }
    }
}

